/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.data.recipe;

import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CompatMetals;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.entry.ItemEntry;
import io.github.jasonsimpart.createdelightcore.CreateDelightCore;
import io.github.jasonsimpart.createdelightcore.data.recipe.FanFreezingRecipeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class CDProcessingRecipeGen
extends BaseRecipeProvider {
    protected static final List<CDProcessingRecipeGen> GENERATORS = new ArrayList<CDProcessingRecipeGen>();

    public static void registerAll(DataGenerator gen, PackOutput output) {
        GENERATORS.add(new FanFreezingRecipeGen(output));
        gen.addProvider(true, new DataProvider(){

            public String m_6055_() {
                return "Create Delight's Processing Recipes";
            }

            public CompletableFuture<?> m_213708_(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.m_213708_(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    public CDProcessingRecipeGen(PackOutput generator) {
        super(generator, "createdelightcore");
    }

    protected <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe create(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        BaseRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, CatnipServices.REGISTRIES.getKeyOrThrow(itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe create(Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("createdelightcore", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe createWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        BaseRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), (ResourceLocation)name.get()))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.createWithDeferredId(() -> name, transform);
    }

    <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(CreateDelightCore.id(name), transform);
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)this.getRecipeType().getSerializer();
    }

    protected Supplier<ResourceLocation> idWithSuffix(Supplier<ItemLike> item, String suffix) {
        return () -> {
            ResourceLocation registryName = CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)item.get()).m_5456_());
            return CreateDelightCore.id(registryName.m_135815_() + suffix);
        };
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Block block, Block result) {
        return this.create(() -> block, b -> b.output((ItemLike)result));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Item item, Item result) {
        return this.create(() -> item, b -> b.output((ItemLike)result));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Supplier<ItemLike> item, Supplier<ItemLike> result) {
        return this.create(item, b -> b.output((ItemLike)result));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Item item, Item result, float chance) {
        return this.create(() -> item, b -> b.output(chance, (ItemLike)result));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Item item, Item result1, float chance1, Item result2, float chance2) {
        return this.create(() -> item, b -> b.output(chance1, (ItemLike)result1).output(chance2, (ItemLike)result2));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(Supplier<ItemLike> item, Supplier<ItemLike> result, float chance) {
        return this.create(item, b -> b.output(chance, (ItemLike)result));
    }

    public BaseRecipeProvider.GeneratedRecipe convert(ItemEntry<Item> item, ItemEntry<Item> result) {
        return this.create(() -> item.get(), b -> b.output(() -> ((ItemEntry)result).get()));
    }

    public BaseRecipeProvider.GeneratedRecipe secondaryRecipe(Supplier<ItemLike> item, Supplier<ItemLike> first, Supplier<ItemLike> secondary, float secondaryChance) {
        return this.create(item, b -> b.output((ItemLike)first.get(), 1).output(secondaryChance, (ItemLike)secondary.get(), 1));
    }

    public BaseRecipeProvider.GeneratedRecipe convertChanceRecipe(ItemLike item, ItemLike result, float chance) {
        return this.create(CreateDelightCore.id(CDProcessingRecipeGen.m_176632_((ItemLike)result) + "_from_" + CDProcessingRecipeGen.m_176632_((ItemLike)item)), b -> b.withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{item})}).output(chance, result, 1));
    }

    public BaseRecipeProvider.GeneratedRecipe crushedOre(Supplier<ItemLike> crushed, ItemLike ingot, ItemLike secondary, float secondaryChance) {
        return this.create(crushed::get, b -> b.output(ingot, 1).output(secondaryChance, secondary, 1));
    }

    public BaseRecipeProvider.GeneratedRecipe moddedCrushedOre(ItemEntry<? extends Item> crushed, CompatMetals metal) {
        String metalName = metal.getName();
        for (Mods mod : metal.getMods()) {
            ResourceLocation ingot = mod.ingotOf(metalName);
            this.create(mod.getId() + "/" + crushed.getId().m_135815_(), b -> {
                Ingredient[] ingredientArray = new Ingredient[1];
                ItemLike[] itemLikeArray = new ItemLike[1];
                itemLikeArray[0] = () -> ((ItemEntry)crushed).get();
                ingredientArray[0] = Ingredient.m_43929_((ItemLike[])itemLikeArray);
                return b.withItemIngredients(ingredientArray).output(1.0f, ingot, 1).output(0.5f, ingot, 1).whenModLoaded(mod.getId());
            });
        }
        return null;
    }
}

